/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1;

import com.roguewave.chart.core.v2_1.ChartPart;
import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.ClickableDrawable;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.SortTreeNode;
import java.io.Serializable;
import java.util.Vector;

public class ChartGraphics
implements Serializable {
    SortTreeNode stn_ = null;
    ChartPart[] parts_ = null;
    Vector twoDDrawables_ = new Vector();
    Vector threeDDrawables_ = new Vector();
    Point3D[] bounds2D_ = null;
    Point3D[] bounds3D_ = null;
    Drawable rescaler_ = null;

    public void add3DTo(Canvas3D canvas) {
        for (int i = 0; i < this.threeDDrawables_.size(); ++i) {
            Drawable temp = (Drawable)this.threeDDrawables_.elementAt(i);
            if (temp instanceof ClickableDrawable) {
                canvas.addClickable((ClickableDrawable)temp);
                continue;
            }
            canvas.addDrawable(temp);
        }
        if (this.stn_ != null) {
            this.stn_.addTo(canvas);
        }
    }

    public void add2DTo(Canvas3D canvas) {
        if (this.rescaler_ != null) {
            canvas.addDrawable(this.rescaler_);
        }
        for (int i = 0; i < this.twoDDrawables_.size(); ++i) {
            Drawable temp = (Drawable)this.twoDDrawables_.elementAt(i);
            if (temp instanceof ClickableDrawable) {
                canvas.addClickable((ClickableDrawable)temp);
                continue;
            }
            canvas.addDrawable(temp);
        }
        if (this.parts_ != null) {
            for (int row = this.parts_.length - 1; row >= 0; --row) {
                this.parts_[row].add2DTo(canvas);
            }
        }
    }

    public void setRescaler(Drawable rescaler) {
        this.rescaler_ = rescaler;
    }

    public void setSortTree(SortTreeNode stn) {
        this.stn_ = stn;
    }

    public void setParts(ChartPart[] parts) {
        this.parts_ = parts;
    }

    public void add2DDrawable(Drawable drawable) {
        this.twoDDrawables_.addElement(drawable);
    }

    public void add3DDrawable(Drawable drawable) {
        this.threeDDrawables_.addElement(drawable);
    }

    void clear() {
        this.stn_ = null;
        this.parts_ = null;
        this.twoDDrawables_ = new Vector();
        this.threeDDrawables_ = new Vector();
    }

    public Point3D[] get2DBoundingBox() {
        return this.bounds2D_;
    }

    public Point3D[] get3DBoundingBox() {
        return this.bounds3D_;
    }

    public void setBounds2D(Point3D[] bounds) {
        this.bounds2D_ = bounds;
    }

    public void setBounds3D(Point3D[] bounds) {
        this.bounds3D_ = bounds;
    }
}

